import nidaqmx

def create_ai_task(channel_name):

    task = nidaqmx.Task()
    task.ai_channels.add_ai_voltage_chan(channel_name)

    return task


def config_daq_timing(task, num, mode, samp_freq):

    if mode == 'Finite':
        option=nidaqmx.constants.AcquisitionType.FINITE
    elif mode == 'Continuous':
        option=nidaqmx.constants.AcquisitionType.CONTINUOUS
    
    task.timing.cfg_samp_clk_timing(rate=samp_freq,
                                    sample_mode=option,
                                    samps_per_chan=num)

    return


def config_daq_triggering(task, trig_pin, edge_option):

    if edge_option == 'Rising':
        option = nidaqmx.constants.Edge.RISING
    else:
        option = nidaqmx.constants.Edge.FALLING

    task.triggers.start_trigger.cfg_dig_edge_start_trig(
                            trig_pin, trigger_edge=option)

    return



def create_ao_task(channel_name):

    task = nidaqmx.Task()    
    task.ao_channels.add_ao_voltage_chan(channel_name)

    return task


def create_do_task(channel_name):

    task = nidaqmx.Task()
    option = nidaqmx.constants.LineGrouping.CHAN_PER_LINE
    task.do_channels.add_do_chan(channel_name,
                                 line_grouping=option)

    return task


def create_ci_task(counter_name, edge_source):

    task = nidaqmx.Task()
    task.ci_channels.add_ci_count_edges_chan(counter_name)
    task.ci_channels.ci_count_edges_term = edge_source

    return task



